

/******************************************************************************************************
 **                                                                                                  **
 **                            Ex4 : Show Emoji on ET-DSP I2C LED 16x8                               **
 **                                                                                                  **
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : Arduino Mega32U4  (ET-Base AVR EASY32U4 LEONADO)                           **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.12                                                             **
 **                                                                                                  **                   
 **  Port Interface     :    Arduino Easy328                         ET-DSP I2C LED16x2              **
 **                         -----------------                       --------------------             **
 **    I2C HT16K33      :  PIN D2-SDA            Connect             SDA                             **                                                                                    
 **                            D3-SCL            Connect             SCL                             **
 **                                                                 I2C Address=0x70                 **
 **                                                                                                  **
 **                                                                                                  **                                                                                                 
 **  Operate : Show Emoji                                                                            ** 
 **                                                                                                  **
 **  Create By          : Mr. Sittiphol Yooyod (WWW.ETTEAM.COM)                                      **
 **  Last Update        : 31/October/2020                                                            ** 
 **                                                                                                  ** 
 **                                 ==== ET-DSP I2C LED 16x2 ====                                    ** 
 **                          [axis-Y=0-7]                                                            **                                   
 **                              ^                                                                   **
 **                        Row   | Even Address       Odd Address --->    Colum                      **
 **                   (D7) ay7   o o o o o o o o    o o o o o o o o                                  ** 
 **                         ^    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **  
 **                   (D0) ay0   o o o o o o o o    o o o o o o o o  ----->   [axis-x=0-15]          **
 **                             ax0           ax7  ax8            ax15                               **         
 **                                                                                                  **
 ******************************************************************************************************/


#include <Wire.h>



/******************************************************
 *                                                    *
 *               Emoji Code                           *
 *                                                    *
 ******************************************************
 *                                                    * 
 * -XSize : 16  pixcels                               *
 * -YSize :  8  pixcels                               *
 *                                                    *
 *                                                    *
 *   End  ..OO-OO.. <- bit7       
 *    ^   ..OO-OO.. <- bit6     (y)                   *
 *    |   ..OO-OO.. <- bit5        ^                  *
 *    |   ..OO-OO.. <- bit4        |                  *
 *    |   ..OO-OO.. <- bit3        |                  *
 *    |   ..OO-OO.. <- bit2        |                  *
 *    |   ..OO-OO.. <- bit1        |                  *
 *  start ..OO-OO.. <- bit0        +----->(x)         *
 *                                                    *   
 *  Byte0-----------> Byte15                          *
 *                                                    *
 *  1 emoji = 16 byte  Seperate 2 row                 *
 ******************************************************/

const unsigned char Emoji_16x8[46][8] PROGMEM = {
        {0x00,0x88,0x50,0x20,0x50,0x88,0x01,0x01}, // Emoji 0
        {0x01,0x01,0x88,0x50,0x20,0x50,0x88,0x00}, // 
        
        {0x00,0x00,0x10,0x12,0x01,0x01,0x01,0x01}, // Emoji 1
        {0x01,0x01,0x01,0x01,0x32,0x30,0x00,0x00}, // 
       
        {0x00,0x70,0x88,0x88,0x73,0x01,0x01,0x01}, // Emoji 2
        {0x01,0x01,0x01,0x71,0x88,0x88,0x70,0x00}, // 
        
        {0x00,0x00,0x08,0x08,0x11,0x62,0x02,0x02}, // Emoji 3
        {0x02,0x02,0x62,0x11,0x08,0x08,0x00,0x00}, // 
        
        {0x00,0x00,0x38,0x41,0x3A,0x02,0x02,0x02}, // Emoji 4
        {0x02,0x02,0x02,0x3A,0x41,0x38,0x00,0x00}, // 
        
        {0x00,0x00,0x70,0x52,0x71,0x01,0x01,0x01}, // Emoji 5
        {0x01,0x01,0x01,0x51,0x22,0x50,0x00,0x00}, // 

        {0x00,0x00,0x20,0x72,0x21,0x01,0x01,0x01}, // Emoji 6
        {0x01,0x01,0x01,0x21,0x72,0x20,0x00,0x00}, // 
        
        {0x00,0x00,0x00,0x00,0x00,0x70,0xF0,0xC5}, // Emoji 7
        {0xCD,0xF8,0x70,0x00,0x00,0x00,0x00,0x00}, // 
       
        {0x00,0x70,0xB8,0x8A,0x71,0x01,0x01,0x01}, // Emoji 8
        {0x01,0x01,0x01,0x71,0xBA,0x88,0x70,0x00}, // 
        
        {0x00,0x20,0x20,0x21,0x72,0x72,0x02,0x02}, // Emoji 9
        {0x02,0x02,0x72,0x72,0x21,0x20,0x20,0x00}, // 
        
        {0x00,0x70,0x70,0x21,0x22,0x22,0x02,0x02}, // Emoji 10
        {0x02,0x02,0x22,0x22,0x21,0x70,0x70,0x00}, // 
        
        {0x00,0x20,0x20,0x21,0x22,0x22,0x02,0x02}, // Emoji 11
        {0x02,0x02,0x02,0x22,0x22,0x21,0x20,0x20}, // 

        {0x00,0x00,0x70,0x70,0x70,0x02,0x01,0x01}, // Emoji 12
        {0x01,0x01,0x02,0x70,0x70,0x70,0x00,0x00}, // 
        
        {0x00,0x30,0x18,0x18,0x18,0x32,0x02,0x02}, // Emoji 13
        {0x02,0x02,0x32,0x18,0x18,0x18,0x30,0x00}, // 
       
        {0x00,0x70,0xC0,0xC0,0xC4,0x072,0x01,0x01}, // Emoji 14
        {0x01,0x01,0x72,0xC4,0xC0,0xC0,0x70,0x00}, // 
        
        {0x38,0x44,0x54,0x44,0x39,0x02,0x02,0x02}, // Emoji 15
        {0x02,0x02,0x02,0x39,0x44,0x54,0x44,0x38}, // 
        
        {0x00,0x00,0x10,0x20,0x40,0x20,0x10,0x02}, // Emoji 16
        {0x02,0x10,0x20,0x40,0x20,0x10,0x00,0x00}, // 
        
        {0x00,0x3C,0x42,0xBD,0xBD,0x42,0x3C,0x00}, // Emoji 17
        {0x00,0x3C,0x42,0xBD,0xBD,0x42,0x3C,0x00}, // 

        {0x00,0x70,0xE8,0xE8,0x70,0x01,0x06,0x04}, // Emoji 18
        {0x04,0x06,0x01,0x70,0xE8,0xE8,0x70,0x00}, // 
        
        {0x00,0x00,0x88,0x90,0x60,0x00,0x04,0x06}, // Emoji 19
        {0x06,0x04,0x00,0x60,0x90,0x88,0x00,0x00}, // 
       
        {0x00,0x00,0x30,0x48,0x30,0x00,0x04,0x02}, // Emoji 20
        {0x02,0x04,0x00,0x30,0x48,0x30,0x00,0x00}, // 
        
        {0x00,0x42,0x24,0x18,0x18,0x24,0x42,0x00}, // Emoji 21
        {0x00,0x42,0x24,0x18,0x18,0x24,0x42,0x00}, // 
        
        {0x00,0x00,0x70,0x48,0x24,0x12,0x09,0x09}, // Emoji 22
        {0x09,0x09,0x12,0x24,0x48,0x70,0x00,0x00}, // 
        
      
};


//-------- HT16K33 commands ---------
  #define HT16K33_CMD_SETUP   0x80
  #define HT16K33_CMD_DIMMING 0xE0 
  
//------- Value Setup for Command ---
  #define Osc_OFF      0x00
  #define Osc_ON       0x01
  #define DSP_OFF      0x00
  #define DSP_ON       0x01
  #define Blink_OFF    0x00
  #define Blink_2H     0x01
  #define Blink_1H     0x02
  #define Blink_0H5    0x03


const int I2C_Addr = 0x70; // HT16K33 default address
unsigned char dspBuf[16];
unsigned char BufOld[16];

 //------------- Setup --------------
void setup() 
{
 Serial.begin(9600);
  Wire.begin();  //Initial Start I2C 
  init_dsp()  ;

}



//================================= Main ================================
void loop() 
{
  char  Enum = 0 , e ;

  for(e=0;e<23;e++)
   {
    emoji(Enum)     ; 
    delay(2000)     ;
    Enum++          ;
   } 

}
 
 

//==================================== Sub-Program ==========================================

//***************************************************
//---------- Function Update Display All -------
//***************************************************

void Dsp_Show()
{
  int nd ;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(0x00)                ; // start at address 0x0
 
  for (nd = 0; nd < 8; nd++) 
  {
    Wire.write(dspBuf[nd])       ; //Write data from buffer array 0-7  for Colum(0-7) address even   
    Wire.write(dspBuf[nd+8])     ; //Write data from buffer array 8-15 for Colum(8-15) address odd    
   
  }
  Wire.endTransmission();  
}

//*********************************************
// Function Initial Display
//*********************************************

void init_dsp()
 {
    Wire.beginTransmission(I2C_Addr)     ;
    Wire.write(0x20 | Osc_ON)            ; // turn on oscillator
    Wire.endTransmission()               ;

    DSP_OnOff(DSP_ON)   ;
    Dimmer(15)          ;     //Dimmer Max 
    Blink( Blink_OFF )  ;

    Clr_buf(0)          ;
    Dsp_Show()          ;
  
    delay(100)          ;

 }


//***********************************************************
//  Function Clear data Buffer of display All 
//        bg = Value data display buffer 0 or 1
//             0 : Data Buffer display all =0x00
//             1 : Data Buffer display all = 0xFF
//-*********************************************************
 
void Clr_buf(int bg)
{
  int nb ;

  if((bg==0)||(bg==1)) //Check bg is 0 or 1 only
   {
     if(bg == 0)
        bg = 0    ;
     else 
       bg = 0xFF  ;
  
    for( nb = 0 ; nb < 8; nb++)
     {
       dspBuf[nb]   = bg;  //Write data to buffer array 0-7  for Colum(0-7) address even   
       dspBuf[nb+8] = bg;  //Write data to buffer array 8-15 for Colum(8-15) address odd  
     }
     
  } //if bg
}

 //************************************************************
 // Function Sets the brightness of the display 
 //        dim = Value Brightness 0-15                      
 //************************************************************
 
void Dimmer(int dim)
 { 
  if(dim > 15) return;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_DIMMING | dim); // Sent Dimming command
  Wire.endTransmission();
}

//***************************************************
 //Function Set display Blinking 
 //        bk = Value blink 0-3
 //             0=Blink off
 //             1=blink 2Hz    
 //             2=blink 1Hz 
 //             3=blink 0.5Hz                   
 //*************************************************

void Blink(int bk)
 {
  if(bk > 3) return;
 
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | bk<<1 | DSP_ON ); //Sent blanking command
  Wire.endTransmission();
}

 //***************************************************
 // Function Set display On/Off 
 //        nf = Value ON/Off Display
 //             0=DSP OFF
 //             1=DSP ON               
 //*************************************************

void DSP_OnOff(int nf)
{
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | nf); //Sent On/Off Display
  Wire.endTransmission();

}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++              Function:Plot Text Ascii 1 Charecter                   ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++                  cha = Ascii Charecter (0x20-0x7F)                  ++
  ++                          or number 0-9                              ++
  ++                   px = Position colum Start plot Char 0-15          ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


 void emoji(unsigned char number)
 {
   unsigned char row,col,px=0  ;
   byte moji                   ;

     Clr_buf(0)                ;     // Clear Display Buffer All 
 
     row = number * 2            ;  //Set Position Start Emoji number by 1 Emoji = 2 row or 16 byte
     
    for(col=0;col<8;col++)                               //Loop Number Byte emoji in 1 Row Array = 8byte
    {
      moji = pgm_read_byte(&Emoji_16x8[row][col])      ;  //Read data emoji 8 byte first    -Row1
      dspBuf[px]    = moji ;                              //keep data to display buffer 0-7
      moji = pgm_read_byte(&Emoji_16x8[row+1][col])    ;  //Read data emoji 8 byte Secound  -Row2
      dspBuf[px+8]  = moji ;                              //keep data to display buffer 8-16
      px++                 ;                              //increment array display buffer
   }
   
  Dsp_Show() ;

 }




 
